# debian_hdgl_full.py
import numpy as np

NOP  = 0x00 << 24
ADD  = 0x01 << 24
MOV  = 0x02 << 24
LOAD = 0x03 << 24
STORE= 0x04 << 24
JMP  = 0x05 << 24
JZ   = 0x06 << 24
JNZ  = 0x07 << 24
OUT  = 0x08 << 24
IN   = 0x09 << 24
HALT = 0xFF << 24

msg = "HDGL Debian booted!\n"
kernel = []
for c in msg:
    kernel += [MOV | 0, ADD | c, OUT | 0]  # load char to r0, print
kernel += [HALT]

kernel_bin = np.array(kernel, dtype=np.uint32)
kernel_bin.tofile("debian_hdgl_full.bin")
print(f"HDGL full Debian kernel generated: {len(kernel_bin)} instructions")
